function [g] = cgammatone(t,fs,f0,bf)
%
%       gammatone : gammatone filters (n=4)
%       Masashi UNOKI (1997.5.27)
%
%       function [z] = gammatone(t,fs,f0,bf)
%       INPUT : t       : Discrete time
%               fs      : Sampling frequency
%               f0      : Center frequency
%               bf      : Parameter of gamma distribution
%       OUTPUT: g       : Gammatone filters
%

if nargin < 1, help gammatone; return; end;

n=4;
A=(2*pi*bf)^4/3;
g = A*(t.^(n-1)).*exp(-2*pi*bf*t).*sin(2*pi*f0*t);

