function xt = IDWT(DWT,f0,fs)
%       IDWT : Inverse Discrete Wavelet Transform
%       Masashi UNOKI
%       26 June 1996
%       8 August 1997 (progressive)
%
%       function [D] = IDWT(DWT,f0,fs)
%       INPUT   : DWT   : DWT vector
%                 f0    : Center frequency
%                 fs    : sampling frequency
%       OUTPUT  : xt    : Reconstructed signal

if nargin < 1, help IDWT; return; end;
if nargin < 3, fs=20000; end;

[Ch L]=size(DWT);
scale = fix(Ch/2);
a = 10^(1/scale);
ERB_GT = 2*f0*(a-1)/(1+a);		% narrow band
ERB_GT=24.7*(4.37*f0/1000+1);           % 1 ERB
bf=1.019*ERB_GT;
R=[];
channel=1;

for i=-scale:scale
   disp(['k=' num2str(i+scale+1) '/' num2str(Ch)]);
   j = 0:1/fs:0.1*a^i;
   J = length(j);
   g = (1/a^(i))*gammatone(j/a^(i),fs,f0,bf);
   rg = fliplr(g);
   idwt = (1/fs)*conv(DWT(channel,:),rg);
   idwt = idwt(J:L+J-1);
   R = [idwt;R];
   channel=channel+1;
end;

xt=R(1,:);
for i=2:Ch
  xt=xt+R(i,:);
end;
