function [Dre,Dim,Ph] = CDWT(data,NumCh,f0,fs)
%	CDWT : Complex Discrete Wavelet Transform
%	Masashi UNOKI
%	26 June 1996
%	8 August 1997 (progressive)
%
%	function [D] = CDWT(data,NumCh,f0,fs)
%	INPUT 	: data	: Input vector
%		  NumCh	: Channel number
%		  f0	: Center frequency
%		  fs	: sampling frequency
%	OUTPUT	: Dre	: Output vector	(real part)
%		: Dim	: Output vector	(imaginary part)
%		: Ph	: Phase vector	

if nargin < 1, help CDWT; return; end;
if nargin < 4, fs=20000; end;

Lx=length(data); 

scale = NumCh/2;
a = 10^(1/scale);
ERB_GT = 2*f0*(a-1)/(1+a);		% narrow band
ERB_GT=24.7*(4.37*f0/1000+1);		% 1 ERB
bf=1.019*ERB_GT;
If=-NumCh/2;
It=NumCh/2;

Dre=zeros(NumCh+1,Lx); Dim=zeros(NumCh+1,Lx);
Ph=zeros(NumCh+1,Lx);
J=0:1/fs:0.1*a^It;
I=[If:It]';
A=a.^I;
IA=1./A;

gtr=(IA*ones(1,length(J))).*gammatone(IA*J,fs,f0,bf);
gti=(IA*ones(1,length(J))).*cgammatone(IA*J,fs,f0,bf);

for n=1:length(I)
   disp(['k=' num2str(n) '/' num2str(NumCh+1)]);
   Jg=0:1/fs:0.1*a^(If+n-1);
   Lg=length(Jg); 
   DWT_re=(1/fs)*conv(gtr(n,1:Lg),data);
   Dre(n,:)=DWT_re(1:Lx);
   DWT_im=(1/fs)*conv(gti(n,1:Lg),data);
   Dim(n,:)=DWT_im(1:Lx);
   Ph(n,:)=atan2(Dim(n,:),Dre(n,:));
end

